import com.phidgets.*;
import com.phidgets.event.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class PressureAvgController1 extends JFrame {
	private InterfaceKitPhidget	interfaceKit;
	private int pressureIndex = 1;
	private int pressure;
	private PressureAvgView1 pv;

	public static void main(String[] args) {
		PressureAvgController1 pc = new PressureAvgController1();
		pc.pack();
		pc.setVisible(true);
		pc.openIntfcKit();
	}

	public PressureAvgController1() {	// Close Phidget intfc kit on exit
		pv= new PressureAvgView1(this);
		Container cp= this.getContentPane();
		cp.add(pv, BorderLayout.CENTER);
		// WindowListener interface has 7 methods
		// WindowAdapter has empty method bodies for all
		// Override only the needed one(s)
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent we) {closeIntfcKit();}
		});
	}

	public int getPressure() { return pressure;}

	private void openIntfcKit() {
		try {
			interfaceKit = new InterfaceKitPhidget();
			interfaceKit.addErrorListener(new ErrorListener() {
				public void error(ErrorEvent ee) {
					System.out.println("Error event for " + ee);
				}
			});
			interfaceKit.addSensorChangeListener(new SensorChangeListener() {
				public void sensorChanged(SensorChangeEvent se) {
					if (se.getIndex() == pressureIndex) {
					    pressure = se.getValue();
					    pv.repaint();
					  }
				}
			});
			interfaceKit.openAny();				// Open first sensor found
			System.out.println("Waiting for PressureSensor attachment...");
			interfaceKit.waitForAttachment();	// Wait for it to be available
			interfaceKit.setRatiometric(true);
			while (!interfaceKit.getRatiometric());		// Confirm ratiometric
		} catch (PhidgetException pe) {
			System.err.println(pe);
		}
	}

	private void closeIntfcKit() {
		System.out.println("Closing...");
		try { 
			interfaceKit.close(); }
		catch (PhidgetException pe) { 
			System.err.println(pe); }
		interfaceKit = null;
		System.exit(0);
	}
}